unit forgas_u;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, ImgList, Buttons, StdCtrls, Menus, ActnList;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    mnuFajl: TMenuItem;
    mnuKilepes: TMenuItem;
    mnuKep: TMenuItem;
    mnuRozsa: TMenuItem;
    mnuKutyus: TMenuItem;
    mnuKiadojel: TMenuItem;
    btnStart: TButton;
    imlRozsa: TImageList;
    imlKiadojel: TImageList;
    imlKutyus: TImageList;
    Timer1: TTimer;
    imgKep: TImage;
    GroupBox1: TGroupBox;
    chkHor: TCheckBox;
    chkVer: TCheckBox;
    Timer2: TTimer;
    mnuAlakzat: TMenuItem;
    mnuNegyszog: TMenuItem;
    Shape1: TShape;
    mnuKor: TMenuItem;
    Timer3: TTimer;
    mnuEllipszis: TMenuItem;
    chkForgoSzoveg: TCheckBox;
    procedure mnuKilepesClick(Sender: TObject);
    procedure btnStartClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure aktKepvaltasExecute(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Timer2Timer(Sender: TObject);
    procedure Timer3Timer(Sender: TObject);
    procedure AlakzatValtas(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation
const
 // kivlaszthat geometriai alakzatok (Shape objektum):
 alakzatok: array [0..2] of TShapeType=(stRectangle, stCircle, stEllipse);
var
 // kpsorozaton bell a kvetkez megjelentend kpkockt jell szmll:
 kepkocka: Integer;
 imlAktualis: TImageList;  // aktulis kpsorozat
 kepek: array [0..2] of TImageList;   // lehetsges kpsorozatok
{$R *.DFM}

procedure TForm1.mnuKilepesClick(Sender: TObject);
begin
  Close;
end;

procedure TForm1.btnStartClick(Sender: TObject);
const
  felirat: array [0..1] of string = ('Start', 'Stop');  // a gomb lehetsges feliratai
  melyik: integer = 1;                                  // a gomb aktulis felirata
begin
  // Az idztk be-, illetve kikapcsolsa:
  Timer1.Enabled:= not Timer1.Enabled;
  Timer2.Enabled:= (chkHor.Checked or chkVer.Checked) and (melyik=1);
  Timer3.Enabled:= not Timer3.Enabled;

  // A Start/Stop gomb feliratnak trsa:
  btnStart.Caption:= felirat[melyik];
  melyik:=abs(melyik - 1);
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var
  s:string;
begin
  // A menben pipval jellt kpsorozat kvetkez
  // kpkockjnak megjelentse:
  kepkocka:=(kepkocka+1) mod imlAktualis.Count;           // lptets
  imlAktualis.GetBitmap(kepkocka, imgKep.Picture.Bitmap); // kp beolvassa
  imgKep.Repaint;                          // az Image objektum trajzolsa

  // Ha be van jellve valamelyik a kt jellngyzet kzl, bekapcsoljuk
  // a msodik idztt is, ellenkez esetben pedig kikapcsoljuk:
  Timer2.Enabled := chkHor.Checked or chkVer.Checked;

  // forgszveg:
  if chkForgoSzoveg.Checked then   // ha bejelltk a jellngyzetet
    begin
     s:=concat(chkForgoSzoveg.Caption,chkForgoSzoveg.Caption[1]); // az els bet beillesztse a szveg vgre
     Delete(s,1,1);                 // az els bet kivgsa
     chkForgoSzoveg.Caption:=s;
    end;
end;

procedure TForm1.aktKepvaltasExecute(Sender: TObject);
var
  i:integer;
begin
  // a Kp men sszes jellpipjnak kikapcsolsa:
  for i:=0 to mnuKep.Count-1 do mnuKep.Items[i].Checked:= false;
  // jellpipa megjelentse az aktulisan kivlasztott menpont eltt:
  (Sender as TMenuItem).Checked:= true;

  imlAktualis:=kepek[(Sender as TMenuItem).MenuIndex]; // az aktulis kpsorozat belltsa
  kepkocka:=0;
  imlAktualis.GetBitmap(kepkocka, imgKep.Picture.Bitmap);
  imgKep.Repaint;

  btnStart.Enabled:=true; // a Start gomb mkdkpess ttele
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  kepkocka:=0;
  randomize;
  Shape1.Pen.Color:=random($00FFFFFF);
  mnuNegyszog.Checked:=true;  // az Alakzat men egyik menpontjnak "kipiplsa"

  // lehetsges kpsorozatok belltsa:
  kepek[0]:=imlRozsa;
  kepek[1]:=imlKutyus;
  kepek[2]:=imlKiadojel;
end;

procedure TForm1.Timer2Timer(Sender: TObject);
const
  dX:integer=-2;
  dY:integer=2;
begin
 if chkHor.Checked then     // vzszintes mozgs
  begin
   if (imgKep.Left<abs(dX)) or (imgKep.Left+imgKep.Width>Form1.ClientWidth-abs(dX))
     then dX:=-dX;
   imgKep.Left:=imgKep.Left+dX;
  end;

 if chkVer.Checked then     // fggleges mozgs
  begin
   if (imgKep.Top<abs(dY)) or (imgKep.Top+imgKep.Height>Form1.ClientHeight-abs(dY))
     then dY:=-dY;
   imgKep.Top:=imgKep.Top+dY;
  end;
end;

procedure TForm1.Timer3Timer(Sender: TObject);
const
  dR:integer = 2;
  dX:integer = 2;
  dY:integer = 1;
  minR:integer = 10;
var
  absDXR, absDYR: integer;
begin
 absDXR:= abs(dX)+abs(dR);
 absDYR:= abs(dY)+abs(dR);

 with Shape1 do
 begin
  if chkHor.Checked then      // vzszintes mozgs
  begin
   if (Left<absDXR) or (Left+Width>Form1.ClientWidth-absDXR)
     then dX:=-dX;
   Left:=Left+dX;
  end;

 if chkVer.Checked then      // fggleges mozgs
  begin
   if (Top<absDYR) or (Top+Height>Form1.ClientHeight-absDYR)
     then dY:=-dY;
   Top:=Top+dY;
  end;

  // tmretezs, hatrelrs ellenrzsvel:
  if (Left+Width>Form1.ClientWidth-absDXR) or (Top+Height>Form1.ClientHeight-absDYR) or (Height<minR) or (Width<minR)
    then dR:=-dR;
  Width:=Width+dR;
  Height:=Height+dR;
 end;
end;

procedure TForm1.AlakzatValtas(Sender: TObject);
var
  i: integer;
begin
  // az Alakzat men sszes jellpipjnak kikapcsolsa:
  for i:=0 to mnuAlakzat.Count-1 do mnuAlakzat.Items[i].Checked:= false;
  // jellpipa megjelentse az aktulisan kivlasztott menpont eltt:
  (Sender as TMenuItem).Checked:= true;

  Shape1.Shape:=alakzatok[(Sender as TMenuItem).MenuIndex];  // alkazatvlts
  Shape1.Pen.Color:=random($00FFFFFF); // az alakzat szne
  Timer3.Enabled:=Timer1.Enabled;      // ha megy a kpvlts, vltozzon az alakzat is
end;
end.
